from tabular_data import Table
import datetime
class order:
    def __init__(self,cart,delivery_date):
        self._order_date=datetime.datetime.today()
        self._products=cart._products
        self._delivery_date=delivery_date
    def __str__(self):
        time_details='Order Date: '+self._order_date.strftime('%A %d %B %Y')
        t=Table(['Product Name', 'Product Price'],\
                    [p.name for p in self._products],\
                    [p.price for p in self._products])
        total=sum([p._price for p in self._products])
        duration = self._delivery_date-datetime.datetime.today()#Note we want today's date not order_date
        delivery_time=self._delivery_date.time().strftime('%I:%M %p')#format is 'hours:minutes am/pm'
        delivery_info='Your delivery is due in '+str(duration.days)+\
                       ' days and should be picked up (or delivered) at '+delivery_time
        return time_details+'\n'+str(t)+'\n'+'Total: '+str(total)+'\n'+delivery_info
        #each part of the string should be displayed on a new line
